<?php
// Weather module for IQ (http://f0rked.com/IQ)
// version: 2.0
// author: f0rked
// Return information about the weather

$this->bind("pubm","","","<prefix>wz ",'weather');
// comment the following line if you wish to disable the shortcut (typing only '<zip>' in a channel)
//$this->bind("pub","","","^[0-9]{5}$",'weather');

$this->functions["weather"]=create_function('$args','
	global $bot;
	$shortcut=0;
	if (strlen($args["msg"])==5) {
		$zip=$args["msg"];
		$shortcut=1;
	}
	else {
		$zip=gettok($args["extmsg"],0);
	}
	if (!is_numeric($zip) || strlen($zip) != 5) {
		$bot->msg($args["target"],"Please specify a valid zip code.");
		return;
	}
	
	$fp=fsockopen("xoap.weather.com",80,$err,$err1,3);
	if (!$fp) {
		$bot->msg($args["target"],"Could not connect to weather.com.");
	}
	else {
		fputs($fp,"GET /weather/local/$zip?cc=* HTTP/1.0\n");
		fputs($fp,"Host: xoap.weather.com\n");
		fputs($fp,"User-Agent: Mozilla/3.0 (compatible;)\n\n");
		
		$_w=array();
		$keys=array();
		
		while (!feof($fp)) {
			$buffer=trim(fgets($fp,4096));
			
			// new key
			if (ereg("^<([^/\?\!]+)>$",$buffer,$regs)) {
				$newkey=gettok($regs[1],0," ");
				if ($newkey == "weather") {
					continue;
				}
				array_push($keys,$newkey);
				
				$keylist="";
				foreach ($keys as $key) {
					$keylist.="$key";
				}
				$_w{$keylist}=array();
			}
			
			// close key
			if (ereg("^</(.+)>$",$buffer,$regs)) {
				$delkey=gettok($regs[1],0," ");
				array_pop($keys);
			}
			
			if (ereg("^<(.+)>(.+)</.+>$",$buffer,$regs)) {
				$keylist="";
				foreach ($keys as $key) {
					$keylist.="$key";
				}
				$_w{$keylist}{$regs[1]}=$regs[2];
			}
		}
		
		//print_r($_w);
		
		if (!$_w["loc"]["dnam"] && !$shortcut) {
			$bot->msg($args["target"],"$zip not found.");
		}
		elseif ($_w["loc"]["dnam"]) {
			$deg=chr(176);
			
			$location=$_w["loc"]["dnam"];
			$temperature=$_w["cc"]["tmp"].$deg.$_w["head"]["ut"];
			$feelslike=$_w["cc"]["flik"].$deg.$_w["head"]["ut"];
			$humidity=$_w["cc"]["hmid"]."%";
			$pressure=$_w["ccbar"]["r"].$_w["head"]["up"]."(".$_w["ccbar"]["d"].")";
			$wind="Wind from ".$_w["ccwind"]["t"]." at ".$_w["ccwind"]["s"].$_w["head"]["us"];
			$condition=$_w["cc"]["t"];
				$output="$location: $temperature (feels like: $feelslike) - $humidity humidity - $pressure - $wind - $condition";
			$bot->msg($args["target"],$output);
		}
	}
');

$this->infoLog("Weather.com module loaded");
?>
