<?php
// IQ standard module (http://f0rked.com/IQ)
// author: f0rked
// This is the standard and recommended module for public access to
// an IQ IRC bot.

$this->bind("join","o","","",'greet_op');
$this->bind("pub","m","","<prefix>cycle","cycle");

$this->bind("pubm","s","","<prefix>restart$","pub_restart");
$this->bind("pubm","r","","<prefix>rehash$","pub_rehash");
$this->bind("pubm","n","","<prefix>eval ","pub_eval");
$this->bind("pubm","s","","<prefix>save$","pub_save");
$this->bind("pubm","n","","<prefix>die$","die");

$this->bind("pubm","m","","<prefix>say ","pub_say");
$this->bind("pubm","m","","<prefix>msg ","pub_msg");
$this->bind("pubm","m","","<prefix>join ","pub_join");
$this->bind("pubm","m","","<prefix>part","pub_part");
$this->bind("pubm","m","","<prefix>raw ","pub_raw");

$this->functions["pub_say"]=create_function('$args','
	global $bot;
	$bot->msg($args["target"],$args["extmsg"]);
');

$this->functions["pub_msg"]=create_function('$args','
	global $bot;
	$target=gettok($args["extmsg"],0);
	$msg=etc(split(" ",$args["extmsg"]),1);
	$bot->msg($args["target"],"Message to $target: $msg");
	$bot->msg($target,$msg);
');

$this->functions["pub_join"]=create_function('$args','
	global $bot;
	$bot->msg($args["target"],"Attempting to join {$args["extmsg"]}");
	$bot->join($args["extmsg"]);
');

$this->functions["pub_part"]=create_function('$args','
	global $bot;
	$chan=gettok($args["extmsg"],0) ? gettok($args["extmsg"],0) : $args["target"];
	$reason=etc(split(" ",$args["extmsg"]),1);
	$bot->part($chan,$reason);
');

$this->functions["pub_raw"]=create_function('$args','
	global $bot;
	$cmd=etc(split(" ",$args["extmsg"]),0);
	$bot->msg($args["target"],"Sending raw command: $cmd");
	$bot->raw($cmd);
');	

$this->functions["cycle"]=create_function('$args','
	global $bot;
	$bot->raw("PART $args[target] :Cycle",false);
	$bot->raw("JOIN $args[target]",false);
	$bot->log($bot->themeize("info",array("Cycle of $args[target] requested by $args[nick]. Cycling..")));
');

$this->functions["pub_restart"]=create_function('$args','
	global $bot;
	$exec=shell_exec("php -l ./include/core.php");
	if (ereg("No syntax errors",$exec)) {
		$bot->log($bot->themeize("info",array("Restart requested by {$args["nick"]}")));
		$bot->raw("QUIT :Restarting",false);
		exit(1);
	}
	else {
		$bot->msg($args["target"],"Compile error; consider revising.");
		$bot->log($bot->themeize("problem",array($exec)));
	}
');

$this->functions["pub_rehash"]=create_function('$args','
	global $bot;
	$bot->rehash();
	$bot->msg($args["target"],"Rehashed.");
');

$this->functions["pub_eval"]=create_function('$args','
	global $bot;
	// Fix $cmd
	$cmd=$args["extmsg"];
	$cmd=str_replace("\$this->","\$bot->",$cmd); // fix context, otherwise bot will commit suicide.
	$bot->log("Raw command from {$args["nick"]}: $cmd");
	$bot->msg($args["target"],eval($cmd));
');

$this->functions["pub_save"]=create_function('$args','
	global $bot;
	if ($bot->saveConfig()) {
		$bot->msg($args["target"],"Configuration saved.");
	}
	else {
		$bot->msg($args["target"],"Failed to save configuration. Check the logs.");
	}
');

$this->functions["die"]=create_function('$args','
	global $bot;
	$bot->raw("QUIT :Shutting down ({$args["nick"]})",false);
	$bot->problemLog("Die command called by {$args["nick"]}, shutting down.");
	exit(0);
');

$this->functions["greet_op"]=create_function('$args','
	global $bot;
	$bot->info["op_queue"][$args["target"]][]=$args["nick"];
	if ($bot->info["channel_users"][$args["target"]][$bot->info["mynick"]]["modes"]["o"]) {
		$bot->mode($args["target"],"+o {$args["nick"]}");
	}
');

$this->infoLog("IQ standard module loaded");
?>
