<?php
/* Standard themes file for IQ
 *   For custom themes, put them in the themes/ directory
 *   as "YOURTHEME.theme.php". Follow the format of the 
 *   themes in this file, and edit your config file to use
 *   your own.
 */

$this->themes["default"]=array(
	"join" => "%1 (%2@%3) joined %4",
	"part" => "%1 (%2@%3) left %4 (%5)",
	"quit" => "%1 has quit (%4)",
	"nick" => "%1 -> %2",
	"kick" => "%1 kicked from %2 by %3",
	
	"mode" => "%1 set mode %2 for %3",
	"lusers" => "[lusers] %1",
	
	"chan_msg" => "[%1] <%2> %5",
	"priv_msg" => "[privmsg] <%2> %5",
	
	"priv_ctcp" => "[privmsg] %2 (%3@%4) CTCP %5: %6", 
	"chan_ctcp" => "[%1] %2 (%3@%4) CTCP %5: %6",
	"priv_action" => "[privmsg] * %2 %5",
	"chan_action" => "[%1] * %2 %5",
	
	"priv_notice" => "-%2(%3@%4)- %5",
	"chan_notice" => "-%2:%1- %5",
	
	"topic" => "* Topic for %1: %2",
	"topic_setby" => "* Set by %1 [%2@%3] %4",
	"topic_change" => "* %1 changed the topic of %2 to: %3",
	
	"self_priv_msg" => "[privmsg:%1] <%2> %3",
	"self_chan_msg" => "[%1] <%2> %3",
	
	"self_priv_notice" => "[notice(%1)] %3",
	"self_chan_notice" => "[notice(%1)] %3",
	
	"info" => ">> %1",
	"problem" => ">> Problem: %1",
	"error" => ">> %1: %2 in %3 (line %4)",
);
		
$this->theme_tags["irssi"]=ctext("-","blue").ctext("!","white").ctext("-","blue")." ";

$this->themes["irssi"]=array(
 	"join" => $this->theme_tags["irssi"].ctext("%1","light_cyan")." ".ctext("[","gray").ctext("%2@%3","cyan").ctext("]","gray")." has joined ".ctext("%4","white"),
	"part" => $this->theme_tags["irssi"].ctext("%1","cyan")." ".ctext("[","gray")."%2@%3".ctext("]","gray")." has left ".ctext("%4","white")." ".ctext("[","gray")."%5".ctext("]","gray"),
	"quit" => $this->theme_tags["irssi"].ctext("%1","cyan")." ".ctext("[","gray")."%2@%3".ctext("]","gray")." has quit ".ctext("[","gray")."%4".ctext("]","gray"),
	"nick" => $this->theme_tags["irssi"].ctext("%1","cyan")." is now known as ".ctext("%2","light_cyan"),
	"kick" => $this->theme_tags["irssi"].ctext("%1","cyan")." was kicked from ".ctext("%2","white")." by ".ctext("%3","white")." ".ctext("[","gray")."%4".ctext("]","gray"),
	
	"mode" => $this->theme_tags["irssi"]."mode/".ctext("%3","light_cyan")." ".ctext("[","gray")."%2".ctext("]","gray")." by ".ctext("%1","white"),
	"lusers" => $this->theme_tags["irssi"]."%1",

	"priv_msg" => ctext("[","gray")."privmsg".ctext("]","gray")." ".ctext("<","gray")."%2".ctext(">","gray")." %5",
	"chan_msg" => ctext("[","gray")."%1".ctext("]","gray")." ".ctext("<","gray")."%2".ctext(">","gray")." %5",
		
	"priv_ctcp" => ctext("%2","light_green")." ".ctext("[","gray").ctext("%3@%4","green").ctext("]","gray")." ".ctext("requested CTCP","green")." ".ctext("%5","light_green").": %6",
	"chan_ctcp" => ctext("%2","light_green")." ".ctext("[","gray").ctext("%3@%4","green").ctext("]","gray")." ".ctext("requested CTCP","green")." ".ctext("%5","light_green").ctext(" from ","green").ctext("%1","light_green").": %6",
		
	"priv_notice" => ctext("-","gray").ctext("%2","light_magenta").ctext("(","gray").ctext("%3@%4","magenta").ctext(")-","gray")." %5",
	"chan_notice" => ctext("-","gray").ctext("%2","light_magenta").ctext(":","gray").ctext("%1","magenta").ctext("-","gray")." %5",
		
	"priv_action" => ctext("[","gray")."privmsg".ctext("]","gray")." ".ctext("* %2","white")." %5",
	"chan_action" => ctext("[","gray")."%1".ctext("]","gray")." ".ctext("* %2","white")." %5",

	"topic" => $this->theme_tags["irssi"]."Topic for ".ctext("%1","light_cyan").": %2",
	"topic_setby" => $this->theme_tags["irssi"]."Topic set by ".ctext("%1","white")." ".ctext("[","gray")."%2@%3".ctext("]","gray")." ".ctext("[","gray")."%4".ctext("]","gray"),
	"topic_change" => $this->theme_tags["irssi"].ctext("%1","white")." changed the topic of ".ctext("%2","white")." to: %3",
	
	"self_priv_msg" => ctext("[","gray")."privmsg".ctext(":","gray")."%1".ctext("]","gray")." ".ctext("<","gray").ctext("%2","white").ctext(">","gray")." %3",
	"self_chan_msg" => ctext("[","gray")."%1".ctext("]","gray")." ".ctext("<","gray").ctext("%2","white").ctext(">","gray")." %3",

	"self_priv_notice" => ctext("[","gray").ctext("notice","red").ctext("(","gray").ctext("%1","light_red").ctext(")","gray").ctext("]","gray")." %3",
	"self_chan_notice" => ctext("[","gray").ctext("notice","red").ctext("(","gray").ctext("%1","light_red").ctext(")","gray").ctext("]","gray")." %3",
	
	"info" => ctext(">>","light_green")." %1",
	"problem" => ctext(">>","light_red")." ".ctext("%1","white"),
	"error" => ctext(">>","white")." ".ctext("%1","red").": %2 in %3 (line %4)",
);
?>
